/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.select;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.api.mixin.client.audio.ISoundHandlerMixin;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.SubGuiInterface;

public class GuiSoundSelection
extends SubGuiInterface
implements ICustomScrollListener {
    private final HashMap<String, List<String>> domains = new HashMap();
    private GuiCustomScroll scrollCategories;
    private GuiCustomScroll scrollQuests;
    private String selectedDomain;
    public ResourceLocation selectedResource;
    private String oldPlay = "";

    public GuiSoundSelection(String sound) {
        this.drawDefaultBackground = false;
        this.title = "";
        this.setBackground("menubg.png");
        this.xSize = 366;
        this.ySize = 226;
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        SoundRegistry registry = ((ISoundHandlerMixin)handler).npcs$getSoundRegistry();
        if (registry != null) {
            Set set = registry.func_148742_b();
            for (ResourceLocation location : set) {
                List list = this.domains.computeIfAbsent(location.func_110624_b(), k -> new ArrayList());
                list.add(location.func_110623_a());
                this.domains.put(location.func_110624_b(), list);
            }
        }
        if (sound != null && !sound.isEmpty()) {
            this.selectedResource = new ResourceLocation(sound);
            this.selectedDomain = this.selectedResource.func_110624_b();
            if (!this.domains.containsKey(this.selectedDomain)) {
                this.selectedDomain = null;
            }
        }
    }

    @Override
    public void func_146284_a(@Nonnull GuiButton guibutton) {
        GuiNpcButton button = (GuiNpcButton)guibutton;
        if (button.field_146127_k == 1 && MusicController.Instance.isPlaying(this.oldPlay)) {
            MusicController.Instance.stopSound(this.oldPlay, SoundCategory.PLAYERS);
            this.oldPlay = "";
            return;
        }
        super.func_146284_a(guibutton);
        if (button.field_146127_k == 1) {
            BlockPos pos = this.player.func_180425_c();
            MusicController.Instance.playSound(SoundCategory.PLAYERS, this.selectedResource.toString(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 1.0f, 1.0f);
            this.oldPlay = this.selectedResource.toString();
        }
        if (button.field_146127_k == 2) {
            this.close();
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addButton(new GuiNpcButton(2, this.guiLeft + this.xSize - 26, this.guiTop + 4, 20, 20, "X"));
        this.addButton(new GuiNpcButton(1, this.guiLeft + 160, this.guiTop + 212, 70, 20, "gui.play", this.selectedResource != null));
        this.getButton(1).setHasSound(false);
        if (this.scrollCategories == null) {
            this.scrollCategories = new GuiCustomScroll(this, 0);
            this.scrollCategories.setSize(90, 200);
        }
        this.scrollCategories.setList(new ArrayList<String>(this.domains.keySet()));
        if (this.selectedDomain != null) {
            this.scrollCategories.setSelected(this.selectedDomain);
        }
        this.scrollCategories.guiLeft = this.guiLeft + 4;
        this.scrollCategories.guiTop = this.guiTop + 14;
        this.addScroll(this.scrollCategories);
        if (this.scrollQuests == null) {
            this.scrollQuests = new GuiCustomScroll(this, 1);
            this.scrollQuests.setSize(250, 200);
        }
        if (this.selectedDomain != null) {
            this.scrollQuests.setList(this.domains.get(this.selectedDomain));
        }
        if (this.selectedResource != null) {
            this.scrollQuests.setSelected(this.selectedResource.func_110623_a());
        }
        this.scrollQuests.guiLeft = this.guiLeft + 95;
        this.scrollQuests.guiTop = this.guiTop + 14;
        this.addScroll(this.scrollQuests);
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (scroll.getID() == 0) {
            this.selectedDomain = scroll.getSelected();
            this.selectedResource = null;
            this.scrollQuests.setSelect(-1);
        }
        if (scroll.getID() == 1) {
            this.selectedResource = new ResourceLocation(this.selectedDomain, scroll.getSelected());
        }
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
        if (this.selectedResource == null) {
            return;
        }
        this.close();
    }

    @Override
    public void func_73876_c() {
        if (this.selectedResource != null && this.getButton(1) != null) {
            boolean pl = MusicController.Instance.isPlaying(this.oldPlay);
            this.getButton(1).setDisplayText(pl ? "gui.stop" : "gui.play");
            if (!pl) {
                this.oldPlay = "";
            }
        }
    }
}

